<?php

class AdminController extends Controller {

    private $entry;

    public function __construct() {
        if (!isset($_SESSION['admin'])) {
            header('Location: /Auth/loginAdmin');
            exit;
        }

        $this->entry = new Entry();
    }

    public function dashboard() {

        $db = Database::connect();

        $stm = $db->query("SELECT COUNT(*) AS c FROM entries WHERE exit_time IS NULL");
        $active = $stm->fetch()['c'];

        $this->view('admin/dashboard', [
            'active' => $active
        ]);
    }

    public function reports() {

        $daily = $this->entry->report('daily');
        $monthly = $this->entry->report('monthly');

        $this->view('admin/reports', [
            'daily' => $daily,
            'monthly' => $monthly
        ]);
    }
}
