<?php

class AuthController extends Controller {

    private $parent;
    private $sms;
    private $user;

    public function __construct() {
        $this->parent = new ParentModel();
        $this->sms = new Sms();
        $this->user = new User();
    }

    public function loginParent() {
        $this->view('auth/login_parent');
    }

    public function sendOtp() {
        $mobile = Helpers::clean($_POST['mobile']);

        if (!preg_match('/^09[0-9]{9}$/', $mobile)) {
            die('شماره معتبر نیست');
        }

        $code = rand(100000, 999999);

        $db = Database::connect();
        $stm = $db->prepare("INSERT INTO otps (mobile, code, expires_at) VALUES (?, ?, DATE_ADD(NOW(), INTERVAL 2 MINUTE))");
        $stm->execute([$mobile, $code]);

        $this->sms->sendOTP($mobile, $code);

        $_SESSION['otp_mobile'] = $mobile;

        $this->view('auth/verify_otp', ['mobile' => $mobile]);
    }

    public function verifyOtp() {
        $mobile = $_SESSION['otp_mobile'] ?? null;
        $code = Helpers::clean($_POST['code']);

        if (!$mobile) die('خطای نشست');

        $db = Database::connect();
        $stm = $db->prepare("SELECT * FROM otps WHERE mobile=? AND code=? AND expires_at > NOW() ORDER BY id DESC LIMIT 1");
        $stm->execute([$mobile, $code]);
        $otp = $stm->fetch();

        if (!$otp) {
            die('کد اشتباه است یا منقضی شده');
        }

        $parent = $this->parent->findByMobile($mobile);

        if (!$parent) {
            $pid = $this->parent->create($mobile);
            $parent = $this->parent->getById($pid);
        }

        $_SESSION['parent_id'] = $parent['id'];

        $this->redirect('/Parent/dashboard');
    }

    public function loginAdmin() {
        $this->view('auth/login_admin');
    }

    public function doLoginAdmin() {
        $username = Helpers::clean($_POST['username']);
        $password = Helpers::clean($_POST['password']);

        $res = $this->user->login($username, $password);

        if (!$res) {
            die('ورود ناموفق');
        }

        $_SESSION['admin'] = $res['id'];
        $this->redirect('/Admin/dashboard');
    }

    public function logout() {
        session_destroy();
        $this->redirect('/');
    }
}
