<?php

class ChildController extends Controller {

    private $child;

    public function __construct() {
        if (!isset($_SESSION['parent_id'])) {
            header('Location: /');
            exit;
        }
        $this->child = new Child();
    }

    public function addForm() {
        $this->view('parent/child_profile');
    }

    public function add() {

        $name = Helpers::clean($_POST['name']);
        $birth = Helpers::clean($_POST['birth']);
        $gender = Helpers::clean($_POST['gender']);

        $photo = null;

        if (!empty($_FILES['photo']['name'])) {
            $photo = Helpers::upload_image($_FILES['photo'], __DIR__ . '/../../public/uploads/children/');
        }

        $this->child->add($_SESSION['parent_id'], $name, $birth, $gender, $photo);

        $this->redirect('/Parent/dashboard');
    }

    public function editForm($id) {

        $child = $this->child->getById($id);

        if ($child['parent_id'] != $_SESSION['parent_id']) die('خطا');

        $this->view('parent/child_profile', ['child' => $child]);
    }

    public function edit($id) {

        $name = Helpers::clean($_POST['name']);
        $birth = Helpers::clean($_POST['birth']);
        $gender = Helpers::clean($_POST['gender']);

        $child = $this->child->getById($id);

        if ($child['parent_id'] != $_SESSION['parent_id']) die('خطا');

        $photo = $child['photo'];

        if (!empty($_FILES['photo']['name'])) {
            $photo = Helpers::upload_image($_FILES['photo'], __DIR__ . '/../../public/uploads/children/');
        }

        $this->child->update($id, $name, $birth, $gender, $photo);

        $this->redirect('/Parent/dashboard');
    }
}
