<?php

class EntryController extends Controller {

    private $entry;
    private $child;
    private $parent;
    private $sms;

    public function __construct() {
        if (!isset($_SESSION['admin'])) {
            header('Location: /Auth/loginAdmin');
            exit;
        }

        $this->entry = new Entry();
        $this->child = new Child();
        $this->parent = new ParentModel();
        $this->sms = new Sms();
    }

    public function enterForm() {

        $this->view('admin/child_entry_form', [
            'children' => []
        ]);
    }

    public function enter() {

        $child_id = $_POST['child_id'];
        $note = $_POST['note'];

        $child = $this->child->getById($child_id);
        $parent = $this->parent->getById($child['parent_id']);

        $entry_id = $this->entry->enter($child_id, $child['parent_id'], $note);

        $time = date("H:i");

        if ($parent['father_mobile'])
            $this->sms->sendEnter($parent['father_mobile'], $child['name'], $time);

        if ($parent['mother_mobile'])
            $this->sms->sendEnter($parent['mother_mobile'], $child['name'], $time);

        $this->redirect('/Admin/dashboard');
    }

    public function exitChild($id) {

        $entry = $this->entry->getActive($id);

        if (!$entry) die('رکورد فعال وجود ندارد');

        $child = $this->child->getById($id);

        $this->entry->exit($entry['id']);

        $parent = $this->parent->getById($child['parent_id']);

        if ($parent['father_mobile'])
            $this->sms->sendExit($parent['father_mobile']);

        if ($parent['mother_mobile'])
            $this->sms->sendExit($parent['mother_mobile']);

        $this->redirect('/Admin/dashboard');
    }
}
