<?php

class Child {

    private $db;

    public function __construct() {
        $this->db = Database::connect();
    }

    // افزودن کودک
    public function add($parent_id, $name, $birth_date, $gender, $photo = null) {
        $sql = "INSERT INTO children (parent_id, name, birth_date, gender, photo)
                VALUES (:pid, :n, :b, :g, :p)";

        $stm = $this->db->prepare($sql);
        $stm->execute([
            ':pid' => $parent_id,
            ':n'   => $name,
            ':b'   => $birth_date,
            ':g'   => $gender,
            ':p'   => $photo
        ]);

        return $this->db->lastInsertId();
    }

    // ویرایش کودک
    public function update($id, $name, $birth_date, $gender, $photo = null) {

        if ($photo) {
            $sql = "UPDATE children SET name=?, birth_date=?, gender=?, photo=?
                    WHERE id=?";
            return $this->db->prepare($sql)->execute([
                $name, $birth_date, $gender, $photo, $id
            ]);
        }

        $sql = "UPDATE children SET name=?, birth_date=?, gender=? WHERE id=?";
        return $this->db->prepare($sql)->execute([
            $name, $birth_date, $gender, $id
        ]);
    }

    // لیست کودکان یک والد
    public function getByParent($parent_id) {
        $stm = $this->db->prepare("SELECT * FROM children WHERE parent_id=? ORDER BY id DESC");
        $stm->execute([$parent_id]);
        return $stm->fetchAll();
    }

    // دریافت کودک بر اساس ID
    public function getById($id) {
        $stm = $this->db->prepare("SELECT * FROM children WHERE id=?");
        $stm->execute([$id]);
        return $stm->fetch();
    }
}
