<?php

class Entry {

    private $db;

    public function __construct() {
        $this->db = Database::connect();
    }

    // ثبت ورود
    public function enter($child_id, $parent_id, $note = null) {
        $sql = "INSERT INTO entries (child_id, parent_id, enter_time, note)
                VALUES (:cid, :pid, NOW(), :n)";
        $stm = $this->db->prepare($sql);
        $stm->execute([
            ':cid' => $child_id,
            ':pid' => $parent_id,
            ':n'   => $note
        ]);
        return $this->db->lastInsertId();
    }

    // گرفتن رکورد فعال کودک (خارج نشده)
    public function getActive($child_id) {
        $sql = "SELECT * FROM entries 
                WHERE child_id = :cid AND exit_time IS NULL
                LIMIT 1";
        $stm = $this->db->prepare($sql);
        $stm->execute([':cid' => $child_id]);
        return $stm->fetch();
    }

    // ثبت خروج + محاسبه هزینه ۱۵ دقیقه‌ای
    public function exit($entry_id) {

        // گرفتن اطلاعات ورود
        $stm = $this->db->prepare("SELECT enter_time FROM entries WHERE id=?");
        $stm->execute([$entry_id]);
        $entry = $stm->fetch();

        if (!$entry) return false;

        $enter = strtotime($entry['enter_time']);
        $exit  = time();

        $minutes = floor(($exit - $enter) / 60);

        // محاسبه هزینه طبق ۱۵ دقیقه
        $cost = $this->calculateCost($minutes);

        $sql = "UPDATE entries
                SET exit_time = NOW(),
                    minutes = :m,
                    cost = :c
                WHERE id = :id";

        $stm2 = $this->db->prepare($sql);
        return $stm2->execute([
            ':m' => $minutes,
            ':c' => $cost,
            ':id' => $entry_id
        ]);
    }

    // محاسبه هزینه ۱۵ دقیقه‌ای
    public function calculateCost($minutes) {

        if ($minutes <= 14) 
            return 0;

        if ($minutes <= 44) 
            return 80000; // نیم ساعت

        if ($minutes <= 74)
            return 120000; // یک ساعت

        // بالاتر از ۱ ساعت به ساعت‌ها گرد می‌شود
        $hours = ceil($minutes / 60);
        return $hours * 120000;
    }

    // گزارش روزانه / ماهانه
    public function report($type = 'daily') {

        if ($type == 'daily') {
            $sql = "SELECT COUNT(*) AS children, SUM(cost) AS total
                    FROM entries
                    WHERE DATE(enter_time) = CURDATE()";
        }
        else {
            $sql = "SELECT COUNT(*) AS children, SUM(cost) AS total
                    FROM entries
                    WHERE MONTH(enter_time) = MONTH(CURDATE())
                    AND YEAR(enter_time) = YEAR(CURDATE())";
        }

        $stm = $this->db->query($sql);
        return $stm->fetch();
    }
}
