<?php

class ParentModel {

    private $db;

    public function __construct() {
        $this->db = Database::connect();
    }

    // یافتن والد با شماره پدر یا مادر
    public function findByMobile($mobile) {
        $sql = "SELECT * FROM parents 
                WHERE father_mobile = :m OR mother_mobile = :m 
                LIMIT 1";
        $stm = $this->db->prepare($sql);
        $stm->execute([':m' => $mobile]);
        return $stm->fetch();
    }

    // ایجاد والد جدید با یکی از شماره‌ها
    public function create($father_mobile, $mother_mobile = null) {
        $sql = "INSERT INTO parents (father_mobile, mother_mobile)
                VALUES (:f, :m)";
        $stm = $this->db->prepare($sql);
        $stm->execute([
            ':f' => $father_mobile,
            ':m' => $mother_mobile
        ]);
        return $this->db->lastInsertId();
    }

    // دریافت اطلاعات کامل والد بر اساس ID
    public function getById($parent_id) {
        $stm = $this->db->prepare("SELECT * FROM parents WHERE id = ?");
        $stm->execute([$parent_id]);
        return $stm->fetch();
    }

    // آپدیت شماره مادر (در صورتی که بعداً وارد شود)
    public function updateMotherMobile($parent_id, $mobile) {
        $sql = "UPDATE parents SET mother_mobile = :m WHERE id = :id";
        $stm = $this->db->prepare($sql);
        return $stm->execute([':m' => $mobile, ':id' => $parent_id]);
    }
}
