<?php

class Sms {

    private $api_key;
    private $sender;
    private $db;

    public function __construct() {
        $config = require __DIR__ . '/../../config.php';
        $this->api_key = $config['sms']['api_key'];
        $this->sender  = $config['sms']['sender'];
        $this->db      = Database::connect();
    }

    // ارسال OTP با pattern کاوه‌نگار
    public function sendOTP($mobile, $code) {

        $url = "https://api.kavenegar.com/v1/{$this->api_key}/verify/lookup.json";

        $params = [
            'receptor' => $mobile,
            'token'    => $code,
            'template' => 'verify'
        ];

        $this->log($mobile, "OTP: $code");

        return $this->post($url, $params);
    }

    // پیامک ورود کودک
    public function sendEnter($mobile, $child_name, $time) {

        $msg = "والد عزیز بادوما، دلبند شما «$child_name» از ساعت «$time» وارد خانه بازی بادوما شد. از طریق لینک زیر میتونید به صورت زنده بازی کردنش رو ببینید: badoma.ir/khane-bazi";
        
        $url = "https://api.kavenegar.com/v1/{$this->api_key}/sms/send.json";

        $params = [
            'receptor' => $mobile,
            'sender'   => $this->sender,
            'message'  => $msg
        ];

        $this->log($mobile, $msg);

        return $this->post($url, $params);
    }

    // پیامک خروج
    public function sendExit($mobile) {

        $msg = "امیدواریم تو بادوما بهتون خوش گذشته باشه.";

        $url = "https://api.kavenegar.com/v1/{$this->api_key}/sms/send.json";

        $params = [
            'receptor' => $mobile,
            'sender'   => $this->sender,
            'message'  => $msg
        ];

        $this->log($mobile, $msg);

        return $this->post($url, $params);
    }

    // ارسال CURL
    private function post($url, $params) {

        $ch = curl_init($url);

        curl_setopt($ch, CURLOPT_POSTFIELDS, $params);
        curl_setopt($ch, CURLOPT_RETURNTRANSFER, true);

        $res = curl_exec($ch);
        curl_close($ch);

        return $res;
    }

    private function log($mobile, $msg) {
        $stm = $this->db->prepare("INSERT INTO sms_logs (mobile, message, status)
                                   VALUES (?, ?, 'pending')");
        $stm->execute([$mobile, $msg]);
    }
}
