<!DOCTYPE html>
<html lang="fa">
<head>
<meta charset="UTF-8">
<title>داشبورد والدین</title>
<link rel="stylesheet" href="/assets/style.css">
</head>
<body>

<div class="container">
    <img src="/logo.png" class="logo-small">

    <h2>کودکان من</h2>

    <a class="btn" href="/Child/addForm">+ افزودن کودک جدید</a>

    <?php if (empty($children)): ?>
        <p>هیچ کودکی ثبت نشده</p>
    <?php else: ?>
        <?php foreach ($children as $child): ?>
            <div class="child-card">
                <img src="/uploads/children/<?= $child['photo'] ?: 'default.png' ?>" class="child-photo">

                <div class="child-info">
                    <h3><?= $child['name'] ?></h3>
                    <p>تاریخ تولد: <?= $child['birth_date'] ?></p>
                    <p>جنسیت: <?= ($child['gender']=='male'?'پسر':'دختر') ?></p>

                    <a class="btn-small" href="/Child/editForm/<?= $child['id'] ?>">ویرایش</a>
                </div>
            </div>
        <?php endforeach; ?>
    <?php endif; ?>
</div>

</body>
</html>
