<?php

class Helpers {

    public static function clean($str) {
        return htmlspecialchars(trim($str), ENT_QUOTES, 'UTF-8');
    }

    public static function now() {
        date_default_timezone_set('Asia/Tehran');
        return date("Y-m-d H:i:s");
    }

    public static function upload_image($file, $path) {
        if (!$file['name']) return null;

        $ext = pathinfo($file['name'], PATHINFO_EXTENSION);
        $newName = time() . '_' . rand(1000,9999) . '.' . $ext;

        move_uploaded_file($file['tmp_name'], $path . $newName);

        return $newName;
    }
}
