<?php

class Router {

    public function run() {

        $url = $_GET['url'] ?? '';

        $parts = explode('/', trim($url, '/'));

        $controller = $parts[0] ?: 'Auth';  // صفحه اول = والدین
        $method = $parts[1] ?? 'loginParent';

        $controllerName = $controller . 'Controller';
        $controllerFile = __DIR__ . '/../app/controllers/' . $controllerName . '.php';

        if (!file_exists($controllerFile)) {
            die("Controller not found!");
        }

        require_once $controllerFile;

        $obj = new $controllerName;

        if (!method_exists($obj, $method)) {
            die("Method not found!");
        }

        unset($parts[0], $parts[1]);

        call_user_func_array([$obj, $method], array_values($parts));
    }
}
